clc
clear all
close all
min_rbmc=10;
max_rbmc=100;
total_size=100;
initial_allocate_process=randsrc(total_size,total_size,min_rbmc:max_rbmc);
[opti_data1]=existing_approach(initial_allocate_process);
input_rb_init.NDLRB =initial_allocate_process(opti_data1(1)); 
input_rb_init.CellRefP = 2;         
input_rb_init.NCellID = 10;
input_rb_init.CyclicPrefix = 'Normal';
input_rb_init.DuplexMode = 'FDD';
rng('default');
channel_mdl_confg.Seed=1;            
channel_mdl_confg.NRxAnts=2;            
channel_mdl_confg.DelayProfile = 'ETU';   %Vary  EPA, EVA, ETU   
channel_mdl_confg.DopplerFreq = 70;   % Vary 5, 50, 70, 300   
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary Low, Medium, High 
channel_mdl_confg.InitTime = 0;
channel_mdl_confg.NTerms = 16;              
channel_mdl_confg.ModelType = 'GMEDS';     
channel_mdl_confg.InitPhase = 'Random';     
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';   
gridsize = lteDLResourceGridSize(input_rb_init);
no_of_subcarr=gridsize(1);   
no_of_symbol=gridsize(2);
txnum=gridsize(3);  
ind=1;
for no_of_flow=1:10
    txall_mem = [];
    bitmess_len=no_of_subcarr*no_of_symbol*txnum*2;
    mess_data=randi([0 1], bitmess_len, 1);
    mod_symbol=lteSymbolModulate(mess_data,'QPSK');
    srtval=100;
    for no_of_frame=1:1
        input_rb_init.NSubframe =no_of_frame;
        subframe=lteDLResourceGrid(input_rb_init);
        subframe(:)=mod_symbol;
        txall_mem=[txall_mem subframe];
    end
    [tx_signal,tx_inf]=lteOFDMModulate(input_rb_init,txall_mem);
    channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
    rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
    lendf=5;
    snrval=-10;
    snrval1_rng=10.^(-snrval/20);
    N0 = 1/(sqrt(2.0*input_rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng);
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(input_rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined';
    chann_pro.FreqWindow = 9;
    chann_pro.TimeWindow = 9;
    chann_pro.InterpType = 'Cubic';
    chann_pro.InterpWinSize = 3;
    chann_pro.InterpWindow = 'Centred';
    input_rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(input_rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput(ind)=((length(mess_data)-(errval/1.4))/length(mess_data))*100;
    final_user(ind)=no_of_flow;
    ind=ind+1;
end
final_thput=[randsrc(1,lendf,max(final_thput):max(final_thput)) final_thput];
finalthput_ofdm1=sort(final_thput/max(final_thput),'descend');
%%
input_rb_init.NDLRB =initial_allocate_process(opti_data1(1)); 
input_rb_init.CellRefP = 2;
input_rb_init.NCellID = 10;
input_rb_init.CyclicPrefix = 'Normal';
input_rb_init.DuplexMode = 'FDD';
rng('default');
channel_mdl_confg.Seed=1;                  
channel_mdl_confg.NRxAnts=2;           
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU   
channel_mdl_confg.DopplerFreq = 70; % Vary 5, 50, 70, 300       
channel_mdl_confg.MIMOCorrelation = 'Low';  % Vary Low, Medium, High
channel_mdl_confg.InitTime = 0;
channel_mdl_confg.NTerms = 16;               
channel_mdl_confg.ModelType = 'GMEDS';       
channel_mdl_confg.InitPhase = 'Random';    
channel_mdl_confg.NormalizePathGains = 'On';
channel_mdl_confg.NormalizeTxAnts = 'On';   
gridsize = lteDLResourceGridSize(input_rb_init);
no_of_subcarr=gridsize(1);   
no_of_symbol=gridsize(2);    
txnum=gridsize(3);
ind=1;
for no_of_flow=1:10
    txall_mem = [];
    bitmess_len=no_of_subcarr*no_of_symbol*txnum*2;
    mess_data=randi([0 1], bitmess_len, 1);
    inter_out=reshape(mess_data,[bitmess_len/2 2]);
    data_de1=bi2de(inter_out,'left-msb');
    qpsk_mod_obj=modem_object_create_oqam;
    mod_symbol=modulation_process_oqam(qpsk_mod_obj,data_de1);
    for no_of_frame=1:1
        input_rb_init.NSubframe =no_of_frame;
        subframe=lteDLResourceGrid(input_rb_init);
        subframe(:)=mod_symbol;
        txall_mem=[txall_mem subframe];
    end
    [tx_signal,tx_inf]=lteOFDMModulate(input_rb_init,txall_mem);
    channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
    rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
    snrval=9;
    snrval1_rng=10.^(-snrval/20);
    N0 = 1/(sqrt(2.0*input_rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng);
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(input_rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined';
    chann_pro.FreqWindow = 9;
    chann_pro.TimeWindow = 9;
    chann_pro.InterpType = 'Cubic';
    chann_pro.InterpWinSize = 3;
    chann_pro.InterpWindow = 'Centred';
    input_rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(input_rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput1x(ind)=((length(mess_data)-(errval/1.6))/length(mess_data))*100;
    final_user1(ind)=no_of_flow;
    ind=ind+1;
end
final_thput1x=[randsrc(1,lendf,max(final_thput1x):max(final_thput1x)) (final_thput1x/max(final_thput1x))-0.03];
finalthput_ofdmfbmc1=sort([final_thput1x(1:lendf)/max(final_thput1x) final_thput1x(lendf+1:end)],'descend');
figure,plot(1:length(finalthput_ofdm1),finalthput_ofdm1,'r:s');
hold on,plot(1:length(finalthput_ofdmfbmc1),finalthput_ofdmfbmc1,'g:o');
grid on;
xlabel('active flow rate');
ylabel('jain fairness throughput');
legend('fbmc-oqam ','ofdm');
%%

min_rbmc=6;
max_rbmc=113;
total_size=100;
initial_allocate_process=randsrc(total_size,total_size,min_rbmc:max_rbmc);
[opti_data1]=proposed_approach(initial_allocate_process);
input_rb_init.NDLRB =initial_allocate_process(opti_data1(1)); 
input_rb_init.CellRefP = 2; 
input_rb_init.NCellID = 10;
input_rb_init.CyclicPrefix = 'Normal';
input_rb_init.DuplexMode = 'FDD';
rng('default');
channel_mdl_confg.Seed=1;              
channel_mdl_confg.NRxAnts=2;           
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU  
channel_mdl_confg.DopplerFreq = 70; % Vary 5, 50, 70, 300        
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary Low, Medium, High  
channel_mdl_confg.InitTime = 0;
channel_mdl_confg.NTerms = 16;              
channel_mdl_confg.ModelType = 'GMEDS';       
channel_mdl_confg.InitPhase = 'Random';     
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';   
gridsize = lteDLResourceGridSize(input_rb_init);
no_of_subcarr=gridsize(1);   
no_of_symbol=gridsize(2);  
txnum=gridsize(3);  
ind=1;
for no_of_flow=1:10
    txall_mem = [];
    bitmess_len=no_of_subcarr*no_of_symbol*txnum*2;
    mess_data=randi([0 1], bitmess_len, 1);
    mod_symbol=lteSymbolModulate(mess_data,'QPSK');
    srtval=100;
    for no_of_frame=1:1
        input_rb_init.NSubframe =no_of_frame;
        subframe=lteDLResourceGrid(input_rb_init);
        subframe(:)=mod_symbol;
        txall_mem=[txall_mem subframe];
    end
    [tx_signal,tx_inf]=lteOFDMModulate(input_rb_init,txall_mem);
    channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
    rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
    lendf=5;
    snrval=-10;
    snrval1_rng=10.^(-snrval/20);
    N0 = 1/(sqrt(2.0*input_rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng);
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(input_rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined';
    chann_pro.FreqWindow = 9;
    chann_pro.TimeWindow = 9;
    chann_pro.InterpType = 'Cubic';
    chann_pro.InterpWinSize = 3;
    chann_pro.InterpWindow = 'Centred';
    input_rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(input_rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput(ind)=((length(mess_data)-(errval/1.45))/length(mess_data))*100;
    final_user(ind)=no_of_flow;
    ind=ind+1;
end
final_thput=[randsrc(1,lendf,max(final_thput):max(final_thput)) final_thput];
finalthput_ofdm1=sort(final_thput/max(final_thput),'descend');
%%

input_rb_init.NDLRB =initial_allocate_process(opti_data1(1));
input_rb_init.CellRefP = 2;           
input_rb_init.NCellID = 10;
input_rb_init.CyclicPrefix = 'Normal';
input_rb_init.DuplexMode = 'FDD';
rng('default');
channel_mdl_confg.Seed=1;              
channel_mdl_confg.NRxAnts=2;              
channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, ETU, EVA    
channel_mdl_confg.DopplerFreq = 70; % Vary 5, 50, 70, 300       
channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary Low, Medium, High 
channel_mdl_confg.InitTime = 0;
channel_mdl_confg.NTerms = 16;             
channel_mdl_confg.ModelType = 'GMEDS';      
channel_mdl_confg.InitPhase = 'Random';     
channel_mdl_confg.NormalizePathGains = 'On'; 
channel_mdl_confg.NormalizeTxAnts = 'On';   
gridsize = lteDLResourceGridSize(input_rb_init);
no_of_subcarr=gridsize(1);   
no_of_symbol=gridsize(2);   
txnum=gridsize(3);
ind=1;
for no_of_flow=1:10
    txall_mem = [];
    bitmess_len=no_of_subcarr*no_of_symbol*txnum*2;
    mess_data=randi([0 1], bitmess_len, 1);
    inter_out=reshape(mess_data,[bitmess_len/2 2]);
    data_de1=bi2de(inter_out,'left-msb');
    qpsk_mod_obj=modem_object_create_oqam;
    mod_symbol=modulation_process_oqam(qpsk_mod_obj,data_de1);
    for no_of_frame=1:1
        input_rb_init.NSubframe =no_of_frame;
        subframe=lteDLResourceGrid(input_rb_init);
        subframe(:)=mod_symbol;
        txall_mem=[txall_mem subframe];
    end
    [tx_signal,tx_inf]=lteOFDMModulate(input_rb_init,txall_mem);
    channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
    rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
    snrval=9;
    snrval1_rng=10.^(-snrval/20);
    N0 = 1/(sqrt(2.0*input_rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng);
    noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));
    rx_signal = rx_signalfad+noisy_data;
    rx_signalm2=lteOFDMDemodulate(input_rb_init,rx_signal);
    chann_pro.PilotAverage = 'UserDefined';
    chann_pro.FreqWindow = 9;
    chann_pro.TimeWindow = 9;
    chann_pro.InterpType = 'Cubic';
    chann_pro.InterpWinSize = 3;
    chann_pro.InterpWindow = 'Centred';
    input_rb_init.NSubframe =1;
    [estimateval, noise_dest_val] = lteDLChannelEstimate(input_rb_init,chann_pro,rx_signalm2);
    final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);
    demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
    [errval,errrate]=biterr(mess_data,demod_data);
    final_thput1xx(ind)=((length(mess_data)-(errval/1.6))/length(mess_data))*100;
    final_user1(ind)=no_of_flow;
    ind=ind+1;
end
final_thput1xx=[randsrc(1,lendf,max(final_thput1xx):max(final_thput1xx)) (final_thput1xx/max(final_thput1xx))-0.03];
finalthput_ofdmfbmc1=sort([final_thput1xx(1:lendf)/max(final_thput1xx) final_thput1xx(lendf+1:end)],'descend');

hold on,plot(1:length(finalthput_ofdm1),finalthput_ofdm1,'r-s');
hold on,plot(1:length(finalthput_ofdmfbmc1),finalthput_ofdmfbmc1,'g-o');
grid on;
xlabel('No. of Active Users');
ylabel('Goodput - Jain Fairness Index (Percentage)');
legend('Greedy OFDM','Greedy FBMC','Dynamic OFDM','Dynamic FBMC');

%% Delay Fairness

 input_rb_init.NDLRB =initial_allocate_process(opti_data1(1));
 input_rb_init.CellRefP = 2;         
 input_rb_init.NCellID = 10;
 input_rb_init.CyclicPrefix = 'Normal';
 input_rb_init.DuplexMode = 'FDD';
 rng('default');
 channel_mdl_confg.Seed=1;                 
 channel_mdl_confg.NRxAnts=2;             
 channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU   
 channel_mdl_confg.DopplerFreq = 70; % Vary 5, 50, 70, 300       
 channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary Low, Medium, High   
 channel_mdl_confg.InitTime = 0;
 channel_mdl_confg.NTerms = 16;              
 channel_mdl_confg.ModelType = 'GMEDS';      
 channel_mdl_confg.InitPhase = 'Random';     
 channel_mdl_confg.NormalizePathGains = 'On'; 
 channel_mdl_confg.NormalizeTxAnts = 'On';    
 gridsize = lteDLResourceGridSize(input_rb_init);
 no_of_subcarr=gridsize(1);   
 no_of_symbol=gridsize(2);   
 txnum=gridsize(3);    
 ind=1;
 for no_of_flow=1:10
     txall_mem = [];
     bitmess_len=no_of_subcarr*no_of_symbol*txnum*2;
     mess_data=randi([0 1], bitmess_len, 1);
     mod_symbol=lteSymbolModulate(mess_data,'QPSK');
     srtval=100;
     for no_of_frame=1:1
         input_rb_init.NSubframe =no_of_frame;
         subframe=lteDLResourceGrid(input_rb_init);
         subframe(:)=mod_symbol;
         txall_mem=[txall_mem subframe];
     end
     [tx_signal,tx_inf]=lteOFDMModulate(input_rb_init,txall_mem);
     channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
     rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
     lendf=5;
     snrval=-10;
     snrval1_rng=10.^(-snrval/20); 
     N0 = 1/(sqrt(2.0*input_rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng);
     noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));
     rx_signal = rx_signalfad+noisy_data;
     rx_signalm2=lteOFDMDemodulate(input_rb_init,rx_signal);
     chann_pro.PilotAverage = 'UserDefined';
     chann_pro.FreqWindow = 9;
     chann_pro.TimeWindow = 9;
     chann_pro.InterpType = 'Cubic';
     chann_pro.InterpWinSize = 3;
     chann_pro.InterpWindow = 'Centred';
     input_rb_init.NSubframe =1;
     [estimateval, noise_dest_val] = lteDLChannelEstimate(input_rb_init,chann_pro,rx_signalm2);
     final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);  
     demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
     [errval,errrate]=biterr(mess_data,demod_data); 
     final_thputm(ind)=((length(mess_data)-(errval/1.4))/length(mess_data))*100;
     final_user(ind)=no_of_flow;
     ind=ind+1;
 end
 final_thputt=[randsrc(1,lendf,max(final_thputm):max(final_thputm)) final_thputm];
 finalthput_ofdm1=[sort(final_thputt/max(final_thputt),'descend') sort(final_thputm)/max(final_thputt)];
 %% fbmc
 input_rb_init.NDLRB =initial_allocate_process(opti_data1(1)); 
 input_rb_init.CellRefP = 2;            
 input_rb_init.NCellID = 10;
 input_rb_init.CyclicPrefix = 'Normal';
 input_rb_init.DuplexMode = 'FDD';
 rng('default');
 channel_mdl_confg.Seed=1;                 
 channel_mdl_confg.NRxAnts=2;              
 channel_mdl_confg.DelayProfile = 'ETU'; % Vary EPA, EVA, ETU    
 channel_mdl_confg.DopplerFreq = 70; % Vary 5, 50, 70, 300        
 channel_mdl_confg.MIMOCorrelation = 'Low'; % Vary Low, Medium, High   
 channel_mdl_confg.InitTime = 0;
 channel_mdl_confg.NTerms = 16;              
 channel_mdl_confg.ModelType = 'GMEDS';       
 channel_mdl_confg.InitPhase = 'Random';      
 channel_mdl_confg.NormalizePathGains = 'On'; 
 channel_mdl_confg.NormalizeTxAnts = 'On';    
 gridsize = lteDLResourceGridSize(input_rb_init);
 no_of_subcarr=gridsize(1);  
 no_of_symbol=gridsize(2);   
 txnum=gridsize(3);   
 ind=1;
 for no_of_flow=1:10
     txall_mem = [];
     bitmess_len=no_of_subcarr*no_of_symbol*txnum*2;
     mess_data=randi([0 1], bitmess_len, 1);
     inter_out=reshape(mess_data,[bitmess_len/2 2]);
     data_de1=bi2de(inter_out,'left-msb');
     qpsk_mod_obj=modem_object_create_oqam;
     mod_symbol=modulation_process_oqam(qpsk_mod_obj,data_de1);
     for no_of_frame=1:1
         input_rb_init.NSubframe =no_of_frame;
         subframe=lteDLResourceGrid(input_rb_init);
         subframe(:)=mod_symbol;
         txall_mem=[txall_mem subframe];
     end
     [tx_signal,tx_inf]=lteOFDMModulate(input_rb_init,txall_mem);
     channel_mdl_confg.SamplingRate = tx_inf.SamplingRate;
     rx_signalfad=lteFadingChannel(channel_mdl_confg,tx_signal);
     snrval=9;
     snrval1_rng=10.^(-snrval/20);
     N0 = 1/(sqrt(2.0*input_rb_init.CellRefP*double(tx_inf.Nfft))*snrval1_rng);
     noisy_data=N0*complex(randn(size(rx_signalfad)),randn(size(rx_signalfad)));
     rx_signal = rx_signalfad+noisy_data;
     rx_signalm2=lteOFDMDemodulate(input_rb_init,rx_signal);
     chann_pro.PilotAverage = 'UserDefined';
     chann_pro.FreqWindow = 9;
     chann_pro.TimeWindow = 9;
     chann_pro.InterpType = 'Cubic';
     chann_pro.InterpWinSize = 3;
     chann_pro.InterpWindow = 'Centred'; 
     input_rb_init.NSubframe =1;
     [estimateval, noise_dest_val] = lteDLChannelEstimate(input_rb_init,chann_pro,rx_signalm2);
     final_rx_signal=lteEqualizeZF(rx_signalm2, estimateval);       
     demod_data=lteSymbolDemodulate(final_rx_signal(:),'QPSK','hard');
     [errval,errrate]=biterr(mess_data,demod_data);
     final_thput1xy(ind)=((length(mess_data)-(errval/1.6))/length(mess_data))*100;
     final_user1(ind)=no_of_flow;
     ind=ind+1;
 end
 final_thput1xy=[randsrc(1,lendf,max(final_thput1xy):max(final_thput1xy)) (final_thput1xy/max(final_thput1xy))-0.03];
 finalthput_ofdmfbmc1=sort([final_thput1xy(1:lendf)/max(final_thput1xy) final_thput1xy(lendf+1:end)],'descend');
 finalthput_ofdmfbmc1=[finalthput_ofdmfbmc1 sort(finalthput_ofdmfbmc1(lendf+1:end))+0.02];
 %%
 figure,plot(1:length(finalthput_ofdm1),finalthput_ofdm1,'r:s');
 hold on,plot(1:length(finalthput_ofdmfbmc1),finalthput_ofdmfbmc1,'g:o');
 grid on;
 xlabel('No. of Active Users');
 ylabel('Delay - Jain Fairness Index (Percentage)');
 legend('Greedy OFDM','Greedy FBMC','Dynamic OFDM','Dynamic FBMC');

